/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.gamestate;

import com.work4games.audio.AudioPlayer;
import com.work4games.entity.Button;
import com.work4games.entity.Explosion;
import com.work4games.entity.Gem;
import com.work4games.entity.Lock;
import com.work4games.entity.Mouse;
import com.work4games.entity.PlayerSave;
import com.work4games.gamestate.GameState;
import com.work4games.gamestate.GameStateManager;
import com.work4games.handlers.Content;
import com.work4games.handlers.Keys;
import com.work4games.tilemap.TileMap;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;

public class PlayState
extends GameState {
    private TileMap tileMap;
    private Mouse mouse;
    private Gem[][] gems;
    private Lock[][] locks;
    private Gem tempGem;
    private Gem tempGem2;
    private ArrayList<Explosion> explosions;
    private ArrayList<Button> buttons;
    private Color pause;
    private int timeFrame = 0;
    private double timeLimit = 200.0;
    private double timeSwitch = this.timeLimit / 66.0;
    private long prevTime;
    boolean updateTime = true;
    private int time;
    private long pausedStartTime;
    private long pausedElapsed;
    private int currentPower = 0;
    private boolean showPowerMenu = false;
    private int currentMoves = 0;
    private boolean gemWait = false;
    private boolean swaped = false;
    private boolean swaping = false;
    private boolean shouldCheck = false;
    private boolean shouldFill = false;
    private boolean soundMatch = true;
    private boolean paused = false;
    private boolean stageCompleted = false;
    private boolean stageFailed = false;

    public PlayState(GameStateManager gsm) {
        this.gsm = gsm;
        this.init();
    }

    @Override
    public void init() {
        this.tileMap = new TileMap(40);
        this.tileMap.loadMap("/Maps/World-1/Level-2.map");
        this.tileMap.init();
        this.pause = new Color(0, 0, 0, 120);
        PlayerSave.init();
        this.mouse = new Mouse();
        this.gems = new Gem[this.tileMap.getNumRows()][this.tileMap.getNumCols()];
        this.locks = new Lock[this.tileMap.getNumRows()][this.tileMap.getNumCols()];
        this.explosions = new ArrayList();
        this.buttons = new ArrayList();
        Button b = new Button(Content.PowerBox, 1, 60, 60, 320, 10);
        this.buttons.add(b);
        Button b2 = new Button(Content.PowerBox, 2, 60, 60, 235, 180);
        this.buttons.add(b2);
        Button b3 = new Button(Content.PowerBox, 5, 60, 60, 235, 290);
        this.buttons.add(b3);
        Button b4 = new Button(Content.PowerBox, 3, 60, 60, 345, 180);
        this.buttons.add(b4);
        Button b5 = new Button(Content.PowerBox, 4, 60, 60, 345, 290);
        this.buttons.add(b5);
        Button b6 = new Button(Content.CirclePauseButton, 6, 60, 40, 55, 35, 495, 10);
        this.buttons.add(b6);
        Button b7 = new Button(Content.CircleResetButton, 7, 60, 40, 55, 35, 565, 10);
        this.buttons.add(b7);
        this.currentMoves = 0;
        this.timeFrame = 0;
        while (this.currentMoves <= 2) {
            int row = 0;
            while (row < this.tileMap.getNumRows()) {
                int col = 0;
                while (col < this.tileMap.getNumCols()) {
                    if (this.tileMap.getTileState(row, col) != 0) {
                        boolean clear = false;
                        while (!clear) {
                            this.gems[row][col] = new Gem(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4, row, col);
                            if (this.checkMatch()) continue;
                            clear = true;
                        }
                    }
                    if (this.tileMap.getTileLocked(row, col)) {
                        this.locks[row][col] = new Lock(this.tileMap.getTileX(row, col), this.tileMap.getTileY(row, col));
                    }
                    ++col;
                }
                ++row;
            }
            this.checkForMoves();
        }
        AudioPlayer.load("/SFX/Match.mp3", "match");
        AudioPlayer.load("/SFX/Match.mp3", "match2");
    }

    @Override
    public void update() {
        this.handleInput();
        if (!this.paused) {
            this.checkSelected();
            if (this.shouldCheck && !this.swaping) {
                this.matchGems();
            }
            if (this.shouldFill) {
                this.fillSpace();
            }
            this.stageCompleted = true;
            this.shouldCheck = true;
            this.swaping = false;
            this.gemWait = false;
            int row = 0;
            while (row < this.tileMap.getNumRows()) {
                int col = 0;
                while (col < this.tileMap.getNumCols()) {
                    Gem gm = this.gems[row][col];
                    if (gm != null) {
                        if (gm.getRemove()) {
                            if (this.tileMap.getTileState(row, col) == 3 && !this.tileMap.getTileLocked(row, col)) {
                                this.tileMap.convert(row, col);
                            }
                            if (this.tileMap.getTileLocked(row, col)) {
                                this.tileMap.setTileLocked(row, col, false);
                                this.locks[row][col].setRemove(true);
                            }
                            Explosion ex = new Explosion(gm.getx() + 1, gm.gety() - 4);
                            this.explosions.add(ex);
                            this.gems[row][col] = null;
                            this.shouldFill = false;
                        } else {
                            gm.update();
                            if (gm.getWait()) {
                                this.gemWait = true;
                            }
                            if (gm.getSwap()) {
                                this.shouldCheck = false;
                                this.swaping = true;
                            }
                            if (this.tileMap.getTileState(row, col) == 3) {
                                this.stageCompleted = false;
                            }
                        }
                    }
                    ++col;
                }
                ++row;
            }
            if (!this.swaping && this.tempGem != null && this.tempGem2 != null) {
                if (!this.checkMatch()) {
                    int trow = this.tempGem.getRow();
                    int tcol = this.tempGem.getCol();
                    int trow2 = this.tempGem2.getRow();
                    int tcol2 = this.tempGem2.getCol();
                    this.gems[trow][tcol].swap(this.gems[trow2][tcol2]);
                    this.gems[trow][tcol] = this.gems[trow2][tcol2];
                    this.gems[trow2][tcol2] = this.tempGem;
                    this.tempGem = null;
                    this.tempGem2 = null;
                } else {
                    this.tempGem = null;
                    this.tempGem2 = null;
                }
            }
            int i = 0;
            while (i < this.buttons.size()) {
                Button b = this.buttons.get(i);
                b.update();
                if (b.intersects(this.mouse)) {
                    b.setHover(true);
                    if (this.mouse.getClicked() && this.showPowerMenu) {
                        if (b.getBID() == 2) {
                            this.currentPower = 2;
                            this.mouse.setType(1);
                            this.showPowerMenu = false;
                        } else if (b.getBID() == 3) {
                            this.currentPower = 3;
                            this.mouse.setType(2);
                            this.showPowerMenu = false;
                        } else if (b.getBID() == 4 && PlayerSave.getToken() >= 8) {
                            PlayerSave.setTime(PlayerSave.getTime() - 30000L);
                            if (PlayerSave.getTime() < 0L) {
                                PlayerSave.setTime(0L);
                            }
                            this.timeFrame = (int)((double)this.timeFrame - 30.0 / this.timeSwitch);
                            if (this.timeFrame < 0) {
                                this.timeFrame = 0;
                            }
                            PlayerSave.addToken(-8);
                            this.showPowerMenu = false;
                        } else if (b.getBID() == 5) {
                            this.currentPower = 5;
                            this.mouse.setType(3);
                            this.showPowerMenu = false;
                        }
                        this.unselectAll();
                    }
                    if (this.mouse.getClicked()) {
                        if (b.getBID() == 1) {
                            this.showPowerMenu = !this.showPowerMenu;
                        } else if (b.getBID() == 6) {
                            this.paused = true;
                        } else if (b.getBID() == 7) {
                            this.init();
                        }
                    }
                } else {
                    b.setHover(false);
                }
                ++i;
            }
            row = 0;
            while (row < this.tileMap.getNumRows()) {
                int col = 0;
                while (col < this.tileMap.getNumCols()) {
                    Lock lk = this.locks[row][col];
                    if (lk != null) {
                        if (lk.getRemove()) {
                            this.locks[row][col] = null;
                        } else {
                            lk.update();
                        }
                    }
                    ++col;
                }
                ++row;
            }
            i = 0;
            while (i < this.explosions.size()) {
                this.explosions.get(i).update();
                if (this.explosions.get(i).getRemove()) {
                    this.explosions.remove(i);
                    --i;
                }
                ++i;
            }
            if (this.explosions.size() == 0) {
                this.shouldFill = true;
            }
            if ((double)(PlayerSave.getTime() - this.prevTime) >= this.timeSwitch * 1000.0 && this.updateTime) {
                this.prevTime = PlayerSave.getTime();
                ++this.timeFrame;
                if (this.timeFrame > 66) {
                    this.timeFrame = 66;
                }
                if (this.timeFrame == 66) {
                    this.stageFailed = true;
                }
            }
            if (!this.swaping || !this.shouldFill) {
                this.checkForMoves();
            }
            if (this.updateTime) {
                this.time = (int)PlayerSave.getTime() / 1000;
            }
            if (this.stageFailed) {
                this.updateTime = false;
                this.swaping = true;
            }
            if (this.stageCompleted) {
                this.updateTime = false;
                this.swaping = true;
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        Gem gm;
        int col;
        g.drawImage((Image)Content.BlueSky, 0, 0, null);
        this.tileMap.draw(g);
        g.setColor(Color.blue);
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            col = 0;
            while (col < this.tileMap.getNumCols()) {
                gm = this.gems[row][col];
                if (gm != null && this.gems[row][col].intersects(this.mouse)) {
                    g.drawRect(gm.getx() - 2, gm.gety() - 2, gm.getWidth() + 4, gm.getHeight() + 4);
                }
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < this.tileMap.getNumRows()) {
            col = 0;
            while (col < this.tileMap.getNumCols()) {
                gm = this.gems[row][col];
                if (gm != null) {
                    gm.draw(g);
                }
                ++col;
            }
            ++row;
        }
        row = 0;
        while (row < this.tileMap.getNumRows()) {
            col = 0;
            while (col < this.tileMap.getNumCols()) {
                Lock lk = this.locks[row][col];
                if (lk != null) {
                    lk.draw(g);
                }
                ++col;
            }
            ++row;
        }
        int i = 0;
        while (i < this.explosions.size()) {
            this.explosions.get(i).draw(g);
            ++i;
        }
        g.drawImage((Image)Content.TopBarHUD, 0, 0, null);
        g.drawImage((Image)Content.TokenB, 385, 20, null);
        if (this.timeFrame <= 66) {
            g.drawImage((Image)Content.Star[0], 160, 15, null);
        } else {
            g.drawImage((Image)Content.Star[1], 160, 15, null);
        }
        if (this.timeFrame < 45) {
            g.drawImage((Image)Content.Star[0], 210, 15, null);
        } else {
            g.drawImage((Image)Content.Star[1], 210, 15, null);
        }
        if (this.timeFrame < 23) {
            g.drawImage((Image)Content.Star[0], 260, 15, null);
        } else {
            g.drawImage((Image)Content.Star[1], 260, 15, null);
        }
        g.drawImage((Image)Content.StarFill[this.timeFrame], 160, 60, null);
        g.setColor(Color.white);
        g.setFont(this.gsm.pixelFont22);
        g.drawString("WORLD 1-1", 10, 48);
        g.drawString("x " + PlayerSave.getToken(), 430, 48);
        g.setFont(this.gsm.pixelFont20);
        this.gsm.drawCenteredString("Score : " + PlayerSave.getScore(), 550, 60, g);
        if (this.showPowerMenu) {
            g.drawImage((Image)Content.PowerMenu, 200, 160, null);
            g.drawImage((Image)Content.TokenS, 273, 250, null);
            g.drawImage((Image)Content.TokenS, 273, 360, null);
            g.drawImage((Image)Content.TokenS, 383, 250, null);
            g.drawImage((Image)Content.TokenS, 383, 360, null);
            g.setFont(this.gsm.pixelFont16);
            this.gsm.drawCenteredString("3 x ", 260, 261, g);
            this.gsm.drawCenteredString("5 x ", 260, 371, g);
            this.gsm.drawCenteredString("5 x ", 370, 261, g);
            this.gsm.drawCenteredString("8 x ", 370, 371, g);
            i = 0;
            while (i < this.buttons.size()) {
                this.buttons.get(i).draw(g);
                ++i;
            }
            g.drawImage((Image)Content.Hammer, 245, 190, null);
            g.drawImage((Image)Content.Bomb, 355, 190, null);
            g.drawImage((Image)Content.CrossArrows, 245, 300, null);
            g.drawImage((Image)Content.RewindTime, 355, 300, null);
        } else {
            i = 0;
            while (i < this.buttons.size()) {
                Button b = this.buttons.get(i);
                if (b.getBID() == 6 || b.getBID() == 1 || b.getBID() == 7) {
                    this.buttons.get(i).draw(g);
                }
                ++i;
            }
        }
        g.setFont(this.gsm.pixelFont14);
        this.gsm.drawCenteredString("Power", 350, 35, g);
        this.gsm.drawCenteredString("Ups", 350, 50, g);
        if (this.stageFailed) {
            this.gsm.drawCenteredString("GAME OVER", 320, 240, g);
        }
        if (this.stageCompleted) {
            this.gsm.drawCenteredString("Stage Completed!", 320, 240, g);
        }
        if (this.paused) {
            g.setColor(this.pause);
            g.fillRect(0, 0, 640, 480);
        }
        this.mouse.draw(g);
    }

    public void matchGems() {
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                if (col + 2 < this.tileMap.getNumCols() && this.gems[row][col] != null && this.gems[row][col + 1] != null && this.gems[row][col + 2] != null && this.gems[row][col].getGemType() == this.gems[row][col + 1].getGemType() && this.gems[row][col].getGemType() == this.gems[row][col + 2].getGemType()) {
                    if (col + 3 < this.tileMap.getNumCols() && this.gems[row][col + 3] != null && this.gems[row][col].getGemType() == this.gems[row][col + 3].getGemType()) {
                        if (col + 4 < this.tileMap.getNumCols() && this.gems[row][col + 4] != null && this.gems[row][col].getGemType() == this.gems[row][col + 4].getGemType()) {
                            this.gems[row][col + 4].setRemove(true);
                            PlayerSave.addScore(10);
                            PlayerSave.addToken(2);
                        }
                        this.gems[row][col + 3].setRemove(true);
                        PlayerSave.addScore(10);
                        PlayerSave.addToken(1);
                    }
                    this.gems[row][col].setRemove(true);
                    this.gems[row][col + 1].setRemove(true);
                    this.gems[row][col + 2].setRemove(true);
                    PlayerSave.addScore(30);
                    if (this.soundMatch) {
                        AudioPlayer.play("match", 1.0);
                    } else {
                        AudioPlayer.play("match2", 1.0);
                    }
                    this.soundMatch = !this.soundMatch;
                }
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.tileMap.getNumCols()) {
            int row2 = 0;
            while (row2 < this.tileMap.getNumRows()) {
                if (row2 + 2 < this.tileMap.getNumRows() && this.gems[row2][col] != null && this.gems[row2 + 1][col] != null && this.gems[row2 + 2][col] != null && this.gems[row2][col].getGemType() == this.gems[row2 + 1][col].getGemType() && this.gems[row2][col].getGemType() == this.gems[row2 + 2][col].getGemType()) {
                    if (row2 + 3 < this.tileMap.getNumRows() && this.gems[row2 + 3][col] != null && this.gems[row2][col].getGemType() == this.gems[row2 + 3][col].getGemType()) {
                        if (row2 + 4 < this.tileMap.getNumRows() && this.gems[row2 + 4][col] != null && this.gems[row2][col].getGemType() == this.gems[row2 + 4][col].getGemType()) {
                            this.gems[row2 + 4][col].setRemove(true);
                            PlayerSave.addScore(10);
                            PlayerSave.addToken(2);
                        }
                        this.gems[row2 + 3][col].setRemove(true);
                        PlayerSave.addScore(10);
                        PlayerSave.addToken(1);
                    }
                    this.gems[row2][col].setRemove(true);
                    this.gems[row2 + 1][col].setRemove(true);
                    this.gems[row2 + 2][col].setRemove(true);
                    PlayerSave.addScore(30);
                    if (this.soundMatch) {
                        AudioPlayer.play("match", 1.0);
                    } else {
                        AudioPlayer.play("match2", 1.0);
                    }
                    this.soundMatch = !this.soundMatch;
                }
                ++row2;
            }
            ++col;
        }
    }

    public boolean checkMatch() {
        boolean match = false;
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                if (col + 2 < this.tileMap.getNumCols() && this.gems[row][col] != null && this.gems[row][col + 1] != null && this.gems[row][col + 2] != null && this.gems[row][col].getGemType() == this.gems[row][col + 1].getGemType() && this.gems[row][col].getGemType() == this.gems[row][col + 2].getGemType()) {
                    match = true;
                }
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.tileMap.getNumCols()) {
            int row2 = 0;
            while (row2 < this.tileMap.getNumRows()) {
                if (row2 + 2 < this.tileMap.getNumRows() && this.gems[row2][col] != null && this.gems[row2 + 1][col] != null && this.gems[row2 + 2][col] != null && this.gems[row2][col].getGemType() == this.gems[row2 + 1][col].getGemType() && this.gems[row2][col].getGemType() == this.gems[row2 + 2][col].getGemType()) {
                    match = true;
                }
                ++row2;
            }
            ++col;
        }
        return match;
    }

    public void fillSpace() {
        int col = this.tileMap.getNumCols() - 1;
        while (col >= 0) {
            int z = 0;
            int row = this.tileMap.getNumRows() - 1;
            while (row >= 0) {
                if (this.tileMap.getTileState(row, col) != 0 && !this.tileMap.getTileLocked(row, col) && this.gems[row][col] == null) {
                    int randomInt;
                    int i;
                    if (row == 0 && !this.gemWait) {
                        this.gems[row][col] = new Gem(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4 - this.tileMap.getTileSize(), row, col);
                        if (this.currentMoves <= 0) {
                            i = 0;
                            while (i < 6) {
                                this.gems[row][col].setGemType(i);
                                this.checkForMoves();
                                if (this.currentMoves >= 1) {
                                    i = 6;
                                }
                                ++i;
                            }
                            if (this.currentMoves <= 0) {
                                randomInt = (int)(Math.random() * 6.0 + 1.0);
                                this.gems[row][col].setGemType(randomInt);
                            }
                        }
                        this.gems[row][col].swap(this.gems[row][col].getx(), this.gems[row][col].gety() + this.tileMap.getTileSize(), row, col);
                    } else if (this.tileMap.getTileSpawn(row, col) && !this.gemWait) {
                        this.gems[row][col] = new Gem(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4 - this.tileMap.getTileSize(), row, col);
                        if (this.currentMoves <= 0) {
                            i = 0;
                            while (i < 6) {
                                this.gems[row][col].setGemType(i);
                                this.checkForMoves();
                                if (this.currentMoves >= 1) {
                                    i = 6;
                                }
                                ++i;
                            }
                            if (this.currentMoves <= 0) {
                                randomInt = (int)(Math.random() * 6.0 + 1.0);
                                this.gems[row][col].setGemType(randomInt);
                            }
                        }
                        this.gems[row][col].swap(this.gems[row][col].getx(), this.gems[row][col].gety() + this.tileMap.getTileSize(), row, col);
                    } else {
                        z = 1;
                        while (row - z >= 0) {
                            if (this.gems[row - z][col] != null) {
                                if (this.tileMap.getTileLocked(row, col) || this.tileMap.getTileLocked(row - z, col)) break;
                                this.gems[row - z][col].swap(this.tileMap.getTileX(row, col) + 4, this.tileMap.getTileY(row, col) + 4, row, col);
                                this.gems[row][col] = this.gems[row - z][col];
                                this.gems[row - z][col] = null;
                                this.swaping = true;
                                break;
                            }
                            ++z;
                        }
                    }
                }
                --row;
            }
            --col;
        }
    }

    public void checkSelected() {
        if (!this.mouse.getClicked()) {
            this.swaped = false;
        }
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                Gem gm = this.gems[row][col];
                if (this.swaped || this.swaping || !this.shouldFill || !this.shouldCheck) break;
                if (gm != null && this.mouse.getClicked() && gm.intersects(this.mouse) && !this.swaped && !this.tileMap.getTileLocked(row, col)) {
                    int c;
                    int r;
                    this.swaped = true;
                    if (this.currentPower == 0 && !this.showPowerMenu) {
                        if (!gm.getSelected()) {
                            gm.setSelected(true);
                        } else {
                            gm.setSelected(false);
                        }
                        int row2 = 0;
                        while (row2 < this.tileMap.getNumRows()) {
                            int col2 = 0;
                            while (col2 < this.tileMap.getNumCols()) {
                                Gem gm2 = this.gems[row2][col2];
                                if (gm2 != null && gm2 != gm) {
                                    if (row2 == row && col2 == col + 1 || row2 == row && col2 == col - 1 || col2 == col && row2 == row + 1 || col2 == col && row2 == row - 1) {
                                        if (gm2.getSelected()) {
                                            gm.swap(gm2);
                                            this.gems[row][col] = gm2;
                                            this.gems[row2][col2] = gm;
                                            this.tempGem = gm;
                                            this.tempGem2 = gm2;
                                            gm.setSelected(false);
                                            gm2.setSelected(false);
                                            this.shouldCheck = false;
                                            this.swaping = true;
                                            break;
                                        }
                                    } else {
                                        gm2.setSelected(false);
                                    }
                                }
                                ++col2;
                            }
                            ++row2;
                        }
                    } else if (this.currentPower == 2 && PlayerSave.getToken() >= 3) {
                        gm.setRemove(true);
                        PlayerSave.addToken(-3);
                        this.mouse.setType(0);
                        this.currentPower = 0;
                    } else if (this.currentPower == 3 && PlayerSave.getToken() >= 5) {
                        r = gm.getRow();
                        c = gm.getCol();
                        int i = -2;
                        while (i < 3) {
                            int j = -2;
                            while (j < 3) {
                                Gem gm2;
                                if (!(r + i >= this.tileMap.getNumRows() || c + j >= this.tileMap.getNumCols() || r + i < 0 || c + j < 0 || (gm2 = this.gems[r + i][c + j]) == null || i == -2 && j != 0 || i == 2 && j != 0 || i != 0 && j == -2 || i != 0 && j == 2)) {
                                    this.gems[r + i][c + j].setRemove(true);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        PlayerSave.addScore(200);
                        PlayerSave.addToken(-5);
                        this.mouse.setType(0);
                        this.currentPower = 0;
                    } else if (this.currentPower == 5 && PlayerSave.getToken() >= 5) {
                        r = gm.getRow();
                        c = gm.getCol();
                        int i = -3;
                        while (i < 4) {
                            if (r + i < this.tileMap.getNumRows() && r + i >= 0) {
                                this.gems[r + i][c].setRemove(true);
                            }
                            ++i;
                        }
                        i = -3;
                        while (i < 4) {
                            if (c + i < this.tileMap.getNumCols() && c + i >= 0) {
                                this.gems[r][c + i].setRemove(true);
                            }
                            ++i;
                        }
                        PlayerSave.addScore(200);
                        PlayerSave.addToken(-5);
                        this.mouse.setType(0);
                        this.currentPower = 0;
                    }
                }
                ++col;
            }
            ++row;
        }
    }

    public void unselectAll() {
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols()) {
                Gem gm = this.gems[row][col];
                if (gm != null) {
                    gm.setSelected(false);
                }
                ++col;
            }
            ++row;
        }
    }

    public void checkForMoves() {
        Gem gm2;
        Gem gm;
        this.currentMoves = 0;
        int row = 0;
        while (row < this.tileMap.getNumRows()) {
            int col = 0;
            while (col < this.tileMap.getNumCols() - 1) {
                gm = this.gems[row][col];
                if (gm != null && !this.tileMap.getTileLocked(row, col) && (gm2 = this.gems[row][col + 1]) != null && !this.tileMap.getTileLocked(row, col + 1)) {
                    this.gems[row][col] = gm2;
                    this.gems[row][col + 1] = gm;
                    if (this.checkMatch()) {
                        ++this.currentMoves;
                    }
                    this.gems[row][col] = gm;
                    this.gems[row][col + 1] = gm2;
                }
                ++col;
            }
            ++row;
        }
        int col = 0;
        while (col < this.tileMap.getNumCols()) {
            int row2 = 0;
            while (row2 < this.tileMap.getNumRows() - 1) {
                gm = this.gems[row2][col];
                if (gm != null && !this.tileMap.getTileLocked(row2, col) && (gm2 = this.gems[row2 + 1][col]) != null && !this.tileMap.getTileLocked(row2 + 1, col)) {
                    this.gems[row2][col] = gm2;
                    this.gems[row2 + 1][col] = gm;
                    if (this.checkMatch()) {
                        ++this.currentMoves;
                    }
                    this.gems[row2][col] = gm;
                    this.gems[row2 + 1][col] = gm2;
                }
                ++row2;
            }
            ++col;
        }
    }

    @Override
    public void handleInput() {
        this.mouse.update();
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Keys.isKeyPressed(Keys.P)) {
            boolean bl = this.paused = !this.paused;
            if (this.paused) {
                this.pausedStartTime = System.nanoTime();
            } else {
                this.pausedElapsed = System.nanoTime() - this.pausedStartTime;
                PlayerSave.setTime(PlayerSave.getTime() - this.pausedElapsed / 1000000L);
            }
        }
        if (Keys.isMousePressed(Keys.RIGHTCLICK)) {
            this.currentPower = 0;
            this.mouse.setType(0);
            this.unselectAll();
        }
        if (Keys.isKeyPressed(Keys.Q)) {
            PlayerSave.addToken(1);
        }
    }
}

